/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.event;

import java.util.Iterator;
import java.util.LinkedList;
import org.dvb.event.RepositoryDescriptor;
import org.dvb.event.UserEvent;

public class UserEventRepository
extends RepositoryDescriptor {
    private LinkedList events = new LinkedList();

    public UserEventRepository(String name) {
        super(null, name);
    }

    public void addUserEvent(UserEvent event) {
        if (this.contains(event)) {
            return;
        }
        this.events.add(event);
    }

    public UserEvent[] getUserEvent() {
        int size = this.events.size();
        UserEvent[] userEvents = new UserEvent[size];
        for (int i = 0; i < size; ++i) {
            userEvents[i] = (UserEvent)this.events.get(i);
        }
        return userEvents;
    }

    public void removeUserEvent(UserEvent event) {
        this.events.remove(event);
    }

    public void addKey(int keycode) {
        this.addUserEvent(new UserEvent(this, 1, 401, keycode, 0, 0L));
        this.addUserEvent(new UserEvent(this, 1, 402, keycode, 0, 0L));
    }

    public void removeKey(int keycode) {
        Iterator it = this.events.iterator();
        while (it.hasNext()) {
            UserEvent event = (UserEvent)it.next();
            if (event.getCode() != keycode) continue;
            it.remove();
        }
    }

    public void addAllNumericKeys() {
        this.addKey(48);
        this.addKey(49);
        this.addKey(50);
        this.addKey(51);
        this.addKey(52);
        this.addKey(53);
        this.addKey(54);
        this.addKey(55);
        this.addKey(56);
        this.addKey(57);
    }

    public void addAllColourKeys() {
        this.addKey(403);
        this.addKey(404);
        this.addKey(405);
        this.addKey(406);
    }

    public void addAllArrowKeys() {
        this.addKey(37);
        this.addKey(39);
        this.addKey(38);
        this.addKey(40);
    }

    public void removeAllNumericKeys() {
        this.removeKey(48);
        this.removeKey(49);
        this.removeKey(50);
        this.removeKey(51);
        this.removeKey(52);
        this.removeKey(53);
        this.removeKey(54);
        this.removeKey(55);
        this.removeKey(56);
        this.removeKey(57);
    }

    public void removeAllColourKeys() {
        this.removeKey(403);
        this.removeKey(404);
        this.removeKey(405);
        this.removeKey(406);
    }

    public void removeAllArrowKeys() {
        this.removeKey(37);
        this.removeKey(39);
        this.removeKey(38);
        this.removeKey(40);
    }

    boolean contains(UserEvent event) {
        Iterator it = this.events.iterator();
        while (it.hasNext()) {
            UserEvent e = (UserEvent)it.next();
            if (e.getFamily() != event.getFamily() || e.getType() != event.getType() || e.getCode() != event.getCode()) continue;
            return true;
        }
        return false;
    }

    private UserEventRepository(UserEventRepository r) {
        super(r.getClient(), r.getName());
        this.events = (LinkedList)r.events.clone();
    }

    protected UserEventRepository getNewInstance() {
        return new UserEventRepository(this);
    }
}

